var main; // a var is required
var tocs = {};
var currentSI;
var currentSSI;
var currentSSM4 = {};

if (typeof String.prototype.endsWith !== 'function') {
    String.prototype.endsWith = function(suffix) {
        return this.indexOf(suffix, this.length - suffix.length) !== -1;
    };
}

$(window).load(function () {
    main = $("body").layout({
        west__showOverflowOnHover: true,
        west__resizable: false,
        west__slidable: false,
        west__togglerLength_open: 50,
        west__togglerAlign_open: 25,
        west__togglerAlign_closed: 25,
        west__spacing_open: 9,
        west__spacing_closed: 9,
        west__size: 220,
        north__resizable: false,
        north__slidable: false,
        north__togglerLength_open: 50,
        north__togglerLength_closed: 50,
        north__togglerAlign_open: -25,
        north__togglerAlign_closed: -25,
        north__spacing_open: 9,
        north__spacing_closed: 9,
        north__onclose_start: function() { $("#printsubmenu").hide(); },
        //,west__fxSettings_open: { easing: "easeOutBounce", duration: 750 }
    });
    window.addEventListener("message", receiveMessage, false);
    if (typeof i18n !== "undefined") {
        $("#service_manual").html(i18n.msg.SERVICE_MANUAL);
    }

    //if ((typeof(shimukeCode) == 'undefined') || (shimukeCode == 'us')) {
    //    $("#wordsearchmenu").hide();
    //}

    if (!('cd' in window)) {
        $("#modelmenu").hide();
    }
    
    if (!tocs.sst) {
        $("#sstmenu").hide();
    }

    var search = location.search;
    var siid = search.replace('?id=', '');

    if (search.lastIndexOf('?dtc=', 0) !== 0 && siid.length == 10) {
        loadNavBySi(siid);
    }
    // SSM3から遷移した場合に、検索結果画面へ遷移 20150720 TSoramoto
    if (getDTC() !== undefined) {
        closeWindow(dtc);
        dtc = window.open("dtc.html?dtc=" + getDTC(), "dtc");
    }
});

function isIE() {
    var myNav = navigator.userAgent.toLowerCase();
    return (myNav.indexOf('msie') != -1) ? parseInt(myNav.split('msie')[1]) : false;
}

// DTCCode取得用 20150720 TSoramoto
function getDTC() {
    var url = location.href;
    params = url.split("?");
    var paramsArray = [];
    for (i = 0; i < params.length; i++) {
        neet = params[i].split("=");
        paramsArray.push(neet[0]);
        paramsArray[neet[0]] = neet[1];
    }
    var dtcCode = paramsArray["dtc"];
    return dtcCode;
}

function receiveMessage(event) {
    // for IE9 (When IE9, send the data as string)
    var eventData = event.data;
    if (typeof eventData == 'string') {
        try {
            eventData = eval('(' + eventData + ')');
        }
        catch (e) {
        }
    }

    if (typeof eventData.openContent != 'undefined') {
        openContent(eventData.openContent);
    }
    if (typeof eventData.openContentWithNavi != 'undefined') {
        openContentWithNavi(eventData.openContentWithNavi);
    }
    if (typeof eventData.openGroup != 'undefined') {
        openGroup(eventData.openGroup);
    }
    if (typeof eventData.contentLoaded != 'undefined') {
        //console.log(eventData.contentLoaded);
    }
    if (typeof eventData.openMainContent != 'undefined') {
        openMainContent(eventData.openMainContent);
    }
    if (typeof eventData.setCurrentSSI != 'undefined') {
        setCurrentSSI(eventData.setCurrentSSI);
    }
    if (typeof eventData.setCurrentSSM4 != 'undefined') {
        setCurrentSSM4(eventData.setCurrentSSM4);
    }
    if (typeof eventData.getCurrentSSM4 != 'undefined') {
        getCurrentSSM4(event.source);
    }
}

function togglePrintSubmenu() {
    if (tocs.sst && $("#titlesisec").text() === "SST") {
        printSI();
    } else {
        $("#printsubmenu").toggle();
    }
}

function closeWindow(win) {
    if (win) {
        if (!win.closed) {
            win.close();
        }
    }
}

var wiring = null;
var dtc = null;
var lookup = null;
var search = null;
var printpage = null;
var submain = null;

function showWiring() {
    closeWindow(wiring);
    wiring = (lang == 'ja') ? window.open("wiring_ja.html", "wiring") : window.open("wiring.html", "wiring");
    wiring.focus();
}

function showDtc() {
    closeWindow(dtc);
    dtc = window.open("dtc.html", "dtc");
    dtc.focus();
}

function showLookup() {
    closeWindow(lookup);
    lookup = (lang == 'ja') ? window.open("lookup_ja.html", "lookup") : window.open("lookup.html", "lookup");
    lookup.focus();
}

function showSearch() {
    closeWindow(search);
    search = window.open("search.html", "search");
    search.focus();
}

function printSSI() {
    if (!currentSSI) {
        alert(i18n.msg.MAIN_TARGETREQUIRED);
        $("#printsubmenu").hide();
        return;
    }
    var filename = "data/print/" + currentSSI + ".html";
    closeWindow(printpage);
    printpage = window.open(filename, "printpage");
    printpage.focus();
    $("#printsubmenu").hide();
}

function printSI() {
    if (!currentSI) {
        alert(i18n.msg.MAIN_TARGETREQUIRED);
        $("#printsubmenu").hide();
        return;
    }
    var filename = "data/print/" + currentSI + ".html";
    closeWindow(printpage);
    printpage = window.open(filename, "printpage");
    printpage.focus();
    $("#printsubmenu").hide();
}

function printSection() {
    if (!currentSI) {
        alert(i18n.msg.MAIN_TARGETREQUIRED);
        $("#printsubmenu").hide();
        return;
    }
    var filename = "data/print/" + currentSI.substring(0,4) + ".html";
    closeWindow(printpage);
    printpage = window.open(filename, "printpage");
    printpage.focus();
    $("#printsubmenu").hide();
}

function showHelp() {
    window.open("help/" + lang + "/scaling.pdf");
}

function showRepairHarness() {
    window.open("repairharness/RH.pdf");
}

function showSst() {
    loadNav($("#sstmenu").text(), "sst");
}

function openGroup(id) {
    window.open("group.html?id=" + id);
}

function loadContent(id) {
    if (!id) return;
    currentSI = id;
    setCurrentSSI(null);
    var filename = "data/" + id.substring(0,4) + "/" + id + ".html" + window.location.hash.toLowerCase();
    $("#content")[0].contentWindow.location.replace(filename);
}

//高機能配線図リンク先ハイライト対応
function loadContentWithoutCode(id) {
    if (!id) return;
    currentSI = id;
    setCurrentSSI(null);
    var hashs = window.location.hash.split('&');

    var filename = "data/" + id.substring(0, 4) + "/" + id + ".html" + hashs[0].toLowerCase();
    $("#content")[0].contentWindow.location.replace(filename);
}

function openContent(id) {
    var filename = "data/" + id.substring(0, 4) + "/" + id.substring(0,10) + ".html";
    if (id.length == 7) {
        filename = "group.html?id=" + id;
    }
    if (id.length > 10) {
        filename += ('#' + id);
    }
    if (window.chrome) {
        window.open(filename);
    } else {
        var newwindow = window.open("about:blank");
        newwindow.location.href = filename;
    }
}

function openContentWithNavi(id) {
    if (id.length == 7) {
        filename = "group.html?id=" + id;
    }
    else {
        filename = "index.html?id=" + id.substring(0, 10);
    }
    if (id.length > 10) {
        filename += ('#' + id);
    }
    if (window.chrome) {
        window.open(filename);
    } else {
        var newwindow = window.open("about:blank");
        newwindow.location.href = filename;
    }
}

function loadNav(title, file) {
    if (file in tocs) {
        $("#treemenu").html(tocs[file]);
    }
    $("#titlesisec").text(title);
    // titlesisecの文字列に合わせて高さを調整
    $("nav.tree").css("padding-top", $("#titlesisec").height() + 2);
    $("#treetop").css("margin-top", -1 * ($("#titlesisec").height() + 2));
    $("#treemenu > ol > li ol").hide();
    $("#treemenu > ol > li label").on("click", function() {
        $(this).closest("li").children("ol").slideToggle("fast");
    });
    $("#treemenu label.si").on("click", function() {
        loadContent($(this).attr("data-id"));
        $("#treemenu li").removeClass("selected");
        $(this).closest("li").addClass("selected");
    });
    $("#treemenu label.sigroup").on("click", function () {
        $("#treemenu li").removeClass("selected");
        $(this).closest("li").addClass("selected");
    });
    $("#treemenu label.sicat").on("click", function () {
        $("#treemenu li").removeClass("selected");
        $(this).closest("li").addClass("selected");
    });
}

function openMainContent(id) {
    var filename = "index.html?id=" + id;
    closeWindow(submain);
    submain = window.open(filename, "submain");
    submain.focus();
}

function loadNavBySi(siid) {
    siid = siid.toLowerCase();
    $.each(tocs, function (idx, toc) {
        var sicatid = siid.substring(0, siid.length - 6);
        var si = $(toc).find("label[data-id^='" + siid + "']");
        if (si.size() > 0) {
            $("#treemenu").html(toc);
            var sisectitle = "";
            $(sisectitles).each(function (index, item) {
                if (item["titleCommonId"] == idx) {
                    sisectitle = item["titleName"];
                }
            });
            $("#titlesisec").html(sisectitle);
            return false;
        }
        return true;
    });

    $("#treemenu > ol > li ol").hide();
    $("#treemenu > ol > li label").on("click", function () {
        $(this).closest("li").children("ol").slideToggle("fast");
    });

    $("#treemenu label.si").on("click", function () {
        //loadContent($(this).attr("data-id"));
        loadContentWithoutCode($(this).attr("data-id"));//高機能配線図リンク先ハイライト対応
        $("#treemenu li").removeClass("selected");
        $(this).closest("li").addClass("selected");
    });

    // open target si
    target = $("#treemenu").find("label[data-id^='" + siid + "']");
    target.parents("ol").each(function () {
        $(this).show();
    });

    target.parent("ol").parent("ol").show();
    loadContent($(target).attr("data-id"));
    $("#treemenu li").removeClass("selected");
    $(target).closest("li").addClass("selected");
    $(target).closest("li").get(0).scrollIntoView();

    // titlesisecの文字列に合わせて高さを調整
    $("nav.tree").css("padding-top", $("#titlesisec").height() + 2);
    $("#treetop").css("margin-top", -1 * ($("#titlesisec").height() + 2));
}

// 選択式SSIにおいて選択されたSSIを設定する
function setCurrentSSI(ssiId) {
    currentSSI = ssiId;
    if (currentSSI) {
        $("#printssimenu").show();
    }
    else {
        $("#printssimenu").hide();
    }
}

// SignalRから配信されたデータを設定する
function setCurrentSSM4(data) {
	$.extend(currentSSM4, data);
}

// SignalRから配信されたデータを返す
function getCurrentSSM4(source) {
    if (window.chrome) {
        source.postMessage({ setCurrentSSM4: currentSSM4 }, '*');
    } else {
        source.setCurrentSSM4(currentSSM4);
    }
}
function toggleShinkaisubmenu() {
	$("#newcarinfosubmenu").toggle();
}
function newcarinfo(newcarinfoMY) {
	window.open("data/pdf/" + newcarinfoMY + ".pdf");
	$("#newcarinfosubmenu").hide();}
